<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Endpoint extends Model 
{

    protected $table = 'endpoints';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function credential()
    {
        return $this->belongsTo('App\Models\Credential');
    }

    public function logs()
    {
        return $this->morphMany('App\Models\Log');
    }

}